;************************************
;************************************
;***** E-mail Template Creator  *****
;*****           by             *****
;*****      Daniel Ford         *****
;*****     July 28, 2009        *****
;************************************
;************************************

;Version 1.0P
;Last Updated June 1, 2020

;**************************
;{***** Program Setup *****

;{-=Load External Libraries and Set Properties=-
XIncludeFile "Includes\OLEedit.pbi"
XIncludeFile "Includes\COMatePlus.pbi"
#COMATE_NOINCLUDEATL = 1
#COMATE_NOERRORREPORTING = 1
#LVM_GETSELECTIONMARK = #LVM_FIRST + 66
;}

;{-=Enumeration=-
Enumeration
  #Window_0; - Main Window
  #ComboBox_Email_Type;          - E-Mail Type
  #ComboBox_Location;            - Location
  #CombBox_AppSystem;              - System
  #ComboBox_SystemType;          - System Selection
  #ComboBox_StartTime1;          - Start Time
  #ComboBox_EndTime1;            - End Time
  #ComboBox_TimeZone;            - TimeZone
  #ComboBox_StartTime2;          - Start Time am/pm
  #ComboBox_EndTime2;            - End Time am/pm
  #ComboBox_StartTimeInterval;   - Start Time Interval
  #ComboBox_EndTimeInterval;     - End Time Interval
  #Email_Body;                   - E-Mail Body
  #Button_Bold;                  - Bold
  #Button_Italic;                - Italic
  #Button_Bullets;               - Bullets
  #Button_Send_Email;            - Send to Outlook
  #Date_1;        - Date Gadget
  #ListIcon_1;    - Application Selection
  #String_1;      - Name/Outage Description
  #String_2;      - Ticket#
  #Text_1;        - Ticket#
  #Text_2;        - Impact on users
  #Image_ButtonImage_1; - Bold Icon
  #Image_ButtonImage_2; - Italic Icon
  #Image_ButtonImage_3; - Bullet Icon
  #Image_ButtonImage_4; - Send to Outlook
  #Font_Editor_0
EndEnumeration
;}

;{-=Define Events & Outlook MSG Object=-
Define.l Event, EventWindow, EventGadget, EventType
Define.COMateObject OutlookObject.COMateObject, olMsg.COMateObject
;}

;{-=Declare Global Variables=-
Global description.s, employee.s, system.s, fromfield.s, mainrecipient.s, cc.s, bcc.s, subject.s, ticket.s
Global combo1.s, combo2.s, combo3.s, combo5.s, combo6.s, combo7.s, combo8.s, combo9.s, combo10.s, combo11.s, combo13.s, combo14.s
Global weekday.s, month.s, date1.s, string1.s, string2.s
Global timezone.s, starttime.s, endtime.s, attach.s, selected.s, totalItemsSelected
Global day, mnth
;}
;}
;**************************

;**************************
;{***** Procedures ********
Procedure FindPartWin(part$)
  r=GetWindow_(GetDesktopWindow_(),#GW_CHILD)
  Repeat
    t$=Space(999) : GetWindowText_(r,t$,999)
    If FindString(LCase(t$), LCase(part$),1)<>0 And IsWindowVisible_(r)=#True
      w=r
    Else
      r=GetWindow_(r,#GW_HWNDNEXT)
    EndIf
  Until r=0 Or w<>0
  ProcedureReturn w
EndProcedure

Procedure CheckForDB()

If GetFileAttributes("DB")=-1
  MessageRequester("Error","Database directory missing, aborting...",#MB_ICONERROR)
   End
ElseIf GetFileAttributes(".\db\applications.txt")=-1
  MessageRequester("Error","Applications.txt is missing, aborting...",#MB_ICONERROR)
   End
ElseIf GetFileAttributes(".\db\logo.rtf")=-1
  MessageRequester("Error","Logo.rtf is missing, aborting...",#MB_ICONERROR)
   End
ElseIf GetFileAttributes(".\db\systems.txt")=-1
  MessageRequester("Error","Systems.txt is missing, aborting...",#MB_ICONERROR)
   End
ElseIf GetFileAttributes(".\db\telecom.txt")=-1
  MessageRequester("Error","Telecom.txt is missing, aborting...",#MB_ICONERROR)
   End
EndIf

EndProcedure

Procedure DisableAppList()
   If GetGadgetText(#CombBox_AppSystem) = "Server or System" And GetGadgetState(#ComboBox_SystemType) > 0
     HideGadget(#ListIcon_1,0)
     DisableGadget(#ListIcon_1,0)
   Else
     HideGadget(#ListIcon_1,1)
     DisableGadget(#ListIcon_1,1)
   EndIf
EndProcedure

Procedure DisableSendButton()
Protected mytype.s, mynumber
  mytype=GetGadgetText(#ComboBox_Email_Type)
   Select mytype

     Case "Close Ticket"
       If GetGadgetText(#String_1)="" Or GetGadgetText(#String_2)=""
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Emergency Maintenance"
       If GetGadgetState(#ComboBox_SystemType)=0
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Helpdesk Ticket Reminder"
       If GetGadgetText(#String_1)="" Or GetGadgetText(#String_1)="During this time you will be unable to " Or GetGadgetText(#String_1)="At this time you should be able to "
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Issue Detected and Resolved"
       If GetGadgetState(#ComboBox_SystemType)=0
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Maintenance"
       If GetGadgetState(#ComboBox_SystemType)=0
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Maintenance Complete"
       If GetGadgetState(#ComboBox_SystemType)=0
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Outage"
       If GetGadgetState(#ComboBox_SystemType)=0
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Resolution"
       If GetGadgetState(#ComboBox_SystemType)=0
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Technology Request Completed"
       If GetGadgetText(#String_1)="" Or GetGadgetText(#String_1)="During this time you will be unable to " Or GetGadgetText(#String_1)="At this time you should be able to "
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Technology Request Needed"
       If GetGadgetText(#String_1)="" Or GetGadgetText(#String_1)="During this time you will be unable to " Or GetGadgetText(#String_1)="At this time you should be able to "
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

     Case "Ticket Follow-Up"
       If GetGadgetText(#String_1)="" Or GetGadgetText(#String_2)=""
         DisableGadget(#Button_Send_Email,1)
       Else
         DisableGadget(#Button_Send_Email,0)
       EndIf

   EndSelect
EndProcedure

Procedure$ DayStr(day)

  Select day
    Case 0 : ProcedureReturn "Sunday"
    Case 1 : ProcedureReturn "Monday"
    Case 2 : ProcedureReturn "Tuesday"
    Case 3 : ProcedureReturn "Wednesday"
    Case 4 : ProcedureReturn "Thursday"
    Case 5 : ProcedureReturn "Friday"
    Case 6 : ProcedureReturn "Saturday"
    Default : ProcedureReturn "Sunday"
  EndSelect

EndProcedure   

Procedure$ MonthStr(month)

  Select month
   Case 1 : ProcedureReturn"January"
   Case 2 : ProcedureReturn"February"
   Case 3 : ProcedureReturn"March"
   Case 4 : ProcedureReturn"April"
   Case 5 : ProcedureReturn"May"
   Case 6 : ProcedureReturn"June"
   Case 7 : ProcedureReturn"July"
   Case 8 : ProcedureReturn"August"
   Case 9 : ProcedureReturn"September"
   Case 10 : ProcedureReturn"October"
   Case 11 : ProcedureReturn"November"
   Case 12 : ProcedureReturn"December"
   Default : ProcedureReturn"January"
  EndSelect

EndProcedure

Procedure FillGadget(LVGadget.l, FileName$)
  If IsGadget(LVGadget) <> 0
    ReadFile(0, FileName$)
      While Eof(FileNr) = 0
        AddGadgetItem(LVGadget, -1, ReadString(FileNr))
      Wend
  EndIf
   CloseFile(FileNr)
EndProcedure

Procedure WinCallback(hwnd, msg, wParam, lParam); Enable Control+Key for Text formatting.
  result = #PB_ProcessPureBasicEvents 
  Select msg 
    Case #WM_NOTIFY 
      *pNMHDR.NMHDR = lParam 
      ; --> Check to see if this is from our EditorGadget 
      Select *pNMHDR\hwndFrom 
        Case GadgetID(#Email_Body)
          Select *pNMHDR\code 
            Case #EN_MSGFILTER 
              *pMSGFILTER.MSGFILTER = lParam 
              mChar = *pMSGFILTER\wParam
              ; --> Get Control key state
              ctrlKey.w = GetKeyState_(#VK_CONTROL) >>15 &$FF
              ; --> Get I key state
              iKey.w = GetKeyState_(#VK_I) >>15 &$FF
              ;************************************************
              ; --> Ctrl + I for Italics
              ;************************************************
              ; --> If the key pressed is the I key and the Control key is down
              ; --> Toggle the italics mode
              If iKey And ctrlKey And mChar = #VK_TAB
                cf2.CHARFORMAT2
                cf2\cbSize = SizeOf(CHARFORMAT2)
                cf2\dwMask = #CFM_ITALIC
                SendMessage_(*pNMHDR\hwndFrom, #EM_GETCHARFORMAT , #SCF_SELECTION, @cf2)
                oldmask = cf2\dwEffects
                If cf2\dwEffects & #CFE_ITALIC  
                  cf2\dwEffects = oldmask ! #CFE_ITALIC 
                Else
                  cf2\dwEffects = oldmask | #CFE_ITALIC 
                EndIf
                SendMessage_(*pNMHDR\hwndFrom, #EM_SETCHARFORMAT, #SCF_SELECTION, cf2)
                ; --> Return non-zero to ignore the Tab char
                result = 1 
              ; --> If the key pressed is the Tab key and Control key is down
              ; --> insert a tab space
              ElseIf ctrlKey And iKey = 0 And mChar = #VK_TAB
                ; --> Return zero to accept the Tab char 
                result = 0
              ; --> If the key pressed is the Tab key only
              ; --> move on to next gadget
              ElseIf iKey = 0 And *pMSGFILTER\msg <> #WM_KEYUP And mChar = #VK_TAB
                hGad = GetNextDlgTabItem_(hwnd, *pNMHDR\hwndFrom, 0)
                nextGad = GetDlgCtrlID_(hGad)
                SetActiveGadget(nextGad)
                ; --> Return non-zero to ignore the Tab char 
                result = 1
              EndIf 
              ;************************************************
              ; --> Ctrl + B for bold
              ;************************************************
              If mChar = 2
                cf2.CHARFORMAT2
                cf2\cbSize = SizeOf(CHARFORMAT2)
                cf2\dwMask = #CFM_BOLD
                SendMessage_(*pNMHDR\hwndFrom, #EM_GETCHARFORMAT , #SCF_SELECTION, @cf2)
                oldmask = cf2\dwEffects
                If cf2\dwEffects & #CFE_BOLD 
                  cf2\dwEffects = oldmask ! #CFE_BOLD 
                Else
                  cf2\dwEffects = oldmask | #CFE_BOLD
                EndIf
                SendMessage_(*pNMHDR\hwndFrom, #EM_SETCHARFORMAT, #SCF_SELECTION, cf2)
                ; --> Return non-zero to ignore the char
                result = 1 
              EndIf
          EndSelect 
      EndSelect 
  EndSelect 
  ProcedureReturn result 
EndProcedure

Procedure ResetMailer(); Reset all back to default
ClearGadgetItems(#ListIcon_1)
 DisableGadget(#Button_Send_Email,1)
  DisableGadget(#ComboBox_Location,1)
   DisableGadget(#CombBox_AppSystem,1)
    DisableGadget(#ComboBox_SystemType,1)
     DisableGadget(#ListIcon_1,1)
      HideGadget(#String_1,1)
       HideGadget(#String_2,1)
        HideGadget(#Text_1,1)
         HideGadget(#Text_2,1)
          HideGadget(#ListIcon_1,1)
           HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
             HideGadget(#ComboBox_TimeZone,1)
              HideGadget(#ComboBox_StartTime2,1)
               HideGadget(#ComboBox_EndTime2,1)
                HideGadget(#ComboBox_StartTimeInterval,1)
                 HideGadget(#ComboBox_EndTimeInterval,1)
                  HideGadget(#Date_1,1)
 SetGadgetState(#ComboBox_Email_Type,0)
  SetGadgetState(#ComboBox_Location,0)
   SetGadgetState(#CombBox_AppSystem,0)
    SetGadgetState(#ComboBox_SystemType,0)
     SetGadgetState(#ComboBox_StartTime1,0)
      SetGadgetState(#ComboBox_EndTime1,0)
       SetGadgetState(#ComboBox_TimeZone,0)
        SetGadgetState(#ComboBox_StartTime2,0)
         SetGadgetState(#ComboBox_EndTime2,0)
          SetGadgetState(#ComboBox_StartTimeInterval,0)
           SetGadgetState(#ComboBox_EndTimeInterval,0)
SetGadgetText(#String_1, "")
 SetGadgetText(#String_2, "")
   SetGadgetText(#Text_2, "Explain Impact on Employees:")
    SetGadgetText(#Email_Body, "")
SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 1)
mainrecipient = ""
 cc = ""
  employee = ""
   subject = ""
    selected = ""
     fromfield = ""
      bcc = ""
       body$ = ""

EndProcedure

Procedure InsertLogo()
Editor_Select(#Email_Body,0,0,0,0)
LoadRTF(#Email_Body,".\DB\logo.rtf",#SF_RTF|#SFF_SELECTION,#False)
EndProcedure

Procedure EmailBody(type.s); Send Text to Editor

combo5=GetGadgetText(#ComboBox_StartTime1)
 combo6=GetGadgetText(#ComboBox_EndTime1)
  combo7=GetGadgetText(#ComboBox_TimeZone)
   combo8=GetGadgetText(#ComboBox_StartTime2)
    combo9=GetGadgetText(#ComboBox_EndTime2)
     combo10=GetGadgetText(#ComboBox_StartTimeInterval)
      combo11=GetGadgetText(#ComboBox_EndTimeInterval)

date=GetGadgetState(#Date_1)
 day=DayOfWeek(date)
  mnth=Month(date)
   month=MonthStr(mnth)
    date1=FormatDate("%dd",date)
     weekday = DayStr(day)

system=GetGadgetText(#ComboBox_SystemType)
 starttime=GetGadgetText(#ComboBox_StartTime1)
  endtime=GetGadgetText(#ComboBox_EndTime1)
   timezone=GetGadgetText(#ComboBox_TimeZone)
    description=GetGadgetText(#String_1)
     string1=GetGadgetText(#String_1)
      string2=GetGadgetText(#String_2)

Select type

  Case "Close Ticket"
;{************************************
mytext.s=GetGadgetText(#String_1)
Debug mytext
;Remove last name
If mytext<>""
  left$=Left(mytext,Len(mytext))
   count=FindString(mytext," ")
  myname.s=Left(left$,count-1)
EndIf
;Remove first name and ,
; If mytext<>""
;   left$=Left(mytext,Len(mytext))
;    count=FindString(mytext,",")
;   myname.s=Right(left$,(Len(left$)-(count+1)))
; EndIf

SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+myname+":"+#CRLF$+#CRLF$
body$ + "IT has attempted to contact you regarding your work order (Ticket#: "+string2+")."
body$ + "  Due to this ticket being 72 hours old with multiple unsuccessful attempts to contact you, your ticket is being closed per IT policy."+#CRLF$+#CRLF$
body$ + "Please do not reply to this e-mail, as this is an unmonitored mailbox.  If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank You,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
 ;}
  Case "Emergency Maintenance"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+employee+" Associates:"+#CRLF$+#CRLF$
If GetGadgetText(#ComboBox_SystemType) <> "E-Mail (Outlook)"
If GetGadgetText(#ComboBox_SystemType) <> "Wireless"
If GetGadgetText(#ComboBox_SystemType) <> "File Servers"
If GetGadgetText(#ComboBox_SystemType) <> "Network"
If GetGadgetText(#ComboBox_SystemType) <> "Network Shared Drives"
EndIf:EndIf:EndIf:EndIf:EndIf
body$ + "Due to recent issues with "+system+", we will perform emergency maintenance on the system.  As a result, "
body$ + system+" will be taken offline on "+weekday+", "+month+" "+date1+" from "+starttime+combo10+" "
body$ + combo8+" to "+endtime+combo11+" "+combo9+" "+timezone+"."
If totalItemsSelected>0;1
body$ + #CRLF$+#CRLF$+"During this maintenance window, you will be unable to access the following applications:"+#CRLF$+#CRLF$+selected+#CRLF$
Else
body$ + "  During this maintenance window, you will be unable to access "+system+"."+#CRLF$+#CRLF$
EndIf
body$ + "We will send an e-mail when the system becomes available.  Please do not try logging into "+system+" at this time."+#CRLF$+#CRLF$
body$ + "We apologize for any inconvenience this may cause."
body$ + "  If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Helpdesk Ticket Reminder"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Please be aware that IT will be reviewing and following up on work orders over two weeks old.  "
body$ + "The following is a list of work orders still open for you and/or your team.  Please take a moment to review these open tickets and confirm if there is an issue that needs further action or if they can be documented and closed by you or your team."+#CRLF$+#CRLF$
body$ + #CRLF$+#CRLF$
body$ + "Please do not reply to this e-mail, as this is an unmonitored mailbox.  If you have any questions or concerns, please contact Tim King (tking@idealtridon.com) for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Issue Detected and Resolved"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+employee+" Associates:"+#CRLF$+#CRLF$
If GetGadgetText(#ComboBox_SystemType) <> "E-Mail (Outlook)"
If GetGadgetText(#ComboBox_SystemType) <> "Wireless"
If GetGadgetText(#ComboBox_SystemType) <> "File Servers"
If GetGadgetText(#ComboBox_SystemType) <> "Network"
If GetGadgetText(#ComboBox_SystemType) <> "Network Shared Drives"
EndIf:EndIf:EndIf:EndIf:EndIf
body$ + "An issue with "+system+" has been detected and resolved.  "+description+#CRLF$+#CRLF$
If totalItemsSelected>1
body$ + "At this time you should be able to access the following applications:"+#CRLF$+#CRLF$+selected+#CRLF$
EndIf
body$ + "If you continue to experience problems with "+system+", please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Maintenance"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+employee+" Associates:"+#CRLF$+#CRLF$
body$ + "Please be aware that "+system+" will be down for routine maintenance on "
body$ + weekday+", "+month+" "+date1+" from "+starttime+combo10+" "+combo8+" to "+endtime+combo11+" "
body$ + combo9+" "+timezone+"."
If totalItemsSelected>0;1
body$ + #CRLF$+#CRLF$+"During this maintenance window, you will be unable to access the following applications:"+#CRLF$+#CRLF$+selected+#CRLF$
Else
body$ + "  During this maintenance window, you will be unable to access "+system+"."+#CRLF$+#CRLF$
EndIf
body$ + "We appreciate your patience while we perform maintenance on these servers.  We will send another e-mail promptly as the systems become available."
body$ + #CRLF$+#CRLF$+"If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Maintenance Complete"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+employee+" Associates:"+#CRLF$+#CRLF$
body$ + "All maintenance on "+system+" is now complete.  Thank you for your patience during this maintenance window."
If totalItemsSelected>1
body$ + "You should now be able to use the following applications:"+#CRLF$+#CRLF$+selected
EndIf
body$ + #CRLF$+#CRLF$+"Should you experience any further issues with "+system
body$ + " or have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Outage"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+employee+" Associates:"+#CRLF$+#CRLF$
If GetGadgetText(#ComboBox_SystemType) <> "E-Mail (Outlook)"
If GetGadgetText(#ComboBox_SystemType) <> "Wireless"
If GetGadgetText(#ComboBox_SystemType) <> "File Servers"
If GetGadgetText(#ComboBox_SystemType) <> "Network"
If GetGadgetText(#ComboBox_SystemType) <> "Network Shared Drives"
EndIf:EndIf:EndIf:EndIf:EndIf
body$ + "We have identified and are investigating an issue with "+system+".  "+description+#CRLF$+#CRLF$
If totalItemsSelected>1
body$ + "At this time you will be unable to access the following applications:"+#CRLF$+#CRLF$+selected+#CRLF$
EndIf
body$ + "We appreciate your patience while we continue our investigation.  We will send another e-mail promptly once we gain more information."+#CRLF$+#CRLF$
body$ + "If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Resolution"
;{************************************
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+employee+" Associates:"+#CRLF$+#CRLF$
If GetGadgetText(#ComboBox_SystemType) <> "E-Mail (Outlook)"
If GetGadgetText(#ComboBox_SystemType) <> "Wireless"
If GetGadgetText(#ComboBox_SystemType) <> "File Servers"
If GetGadgetText(#ComboBox_SystemType) <> "Network"
If GetGadgetText(#ComboBox_SystemType) <> "Network Shared Drives"
EndIf:EndIf:EndIf:EndIf:EndIf
body$ + "The issues affecting "+system+" have been resolved.  "+description+#CRLF$+#CRLF$
If totalItemsSelected>1
body$ + "At this time you should be able to access the following applications:"+#CRLF$+#CRLF$+selected+#CRLF$
EndIf
body$ + "If you continue to experience problems with "+system+", please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Technology Request Completed"
;{************************************
mytext.s=GetGadgetText(#String_1)
;Remove last name
If mytext<>""
  left$=Left(mytext,Len(mytext))
   count=FindString(mytext," ")
  myname.s=Left(left$,count-1)
EndIf
;Remove first name and ,
; If mytext<>""
;   left$=Left(mytext,Len(mytext))
;    count=FindString(mytext,",")
;   myname.s=Right(left$,(Len(left$)-(count+1)))
; EndIf
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+myname+":"+#CRLF$+#CRLF$
body$ + "Please be aware that your Technology Request has been completed by IT.  Attached to this e-mail is a copy of the completed IT Information Card."+#CRLF$
body$ + "The IT Information Card contains all of your logon names and passwords for your applications and PC."+#CRLF$+#CRLF$
body$ + "Please do not reply to this e-mail, as this is an unmonitored mailbox.  If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Technology Request Needed"
;{************************************
mytext.s=GetGadgetText(#String_1)
;Remove last name
If mytext<>""
  left$=Left(mytext,Len(mytext))
   count=FindString(mytext," ")
  myname.s=Left(left$,count-1)
EndIf
;Remove first name and ,
; If mytext<>""
;   left$=Left(mytext,Len(mytext))
;    count=FindString(mytext,",")
;   myname.s=Right(left$,(Len(left$)-(count+1)))
; EndIf
SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+myname+":"+#CRLF$+#CRLF$
body$ + "Please be aware that your request (Ticket#: "+string2+") will require a Technology Request Form to be filled out by your supervisor.  "+#CRLF$+#CRLF$
body$ + "Below is a link to the Technology Request Form:"+#CRLF$+#CRLF$
body$ + "http://tn-shrpnt/sites/new/IT/_layouts/15/FormServer.aspx?XsnLocation=http://tn-shrpnt/sites/new/IT/ITRequestForms/Forms/template.xsn&SaveLocation=http%3A%2F%2Ftn-shrpnt%2Fsites%2Fnew%2FIT%2FITRequestForms&ClientInstalled=false&DefaultItemOpen=0&Source=http%3A%2F%2Ftn-shrpnt%2Fsites%2Fnew%2FIT%2FITRequestForms%2FForms%2FAllItems%2Easpx"+#CRLF$+#CRLF$
body$ + "Your Helpdesk ticket will be closed as we await your Technology Request Form to be completed by your supervisor."
body$ + #CRLF$+#CRLF$
body$ + "Please do not reply to this e-mail, as this is an unmonitored mailbox.  If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank you,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
  Case "Ticket Follow-Up"
;{************************************
mytext.s=GetGadgetText(#String_1)
;Remove last name
If mytext<>""
  left$=Left(mytext,Len(mytext))
   count=FindString(mytext," ")
  myname.s=Left(left$,count-1)
EndIf
;Remove first name and ,
; If mytext<>""
;   left$=Left(mytext,Len(mytext))
;    count=FindString(mytext,",")
;   myname.s=Right(left$,(Len(left$)-(count+1)))
; EndIf

SetGadgetText(#Email_Body,"")
body$ + #CRLF$
body$ + "Dear "+myname+":"+#CRLF$+#CRLF$
body$ + "IT has attempted to contact you regarding your work order (Ticket#: "+string2+")."
body$ + "  After multiple unsuccessful attempts in a 72-hour period, your ticket will be closed per IT policy."+#CRLF$+#CRLF$
body$ + "Please do not reply to this e-mail, as this is an unmonitored mailbox.  If you have any questions or concerns, please contact the Helpdesk at itsupport@idealtridon.com for assistance."+#CRLF$+#CRLF$+#CRLF$
body$ + "Thank You,"+#CRLF$+#CRLF$
body$ + "Ideal Information Technology"
InsertLogo()
editor_inserttext(#Email_Body,body$)
totalItemsSelected=0
;}
EndSelect

EndProcedure

Procedure MailType(); Enable/Disable gadgets according to mail type

combo1=GetGadgetText(#ComboBox_Email_Type)

Select combo1

  Case "Select E-Mail Type:";*** Nothing Selected ***
;{************************************
            SetGadgetText(#String_1, "")
            DisableGadget(#ComboBox_Location,1)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ListIcon_1,1)
            DisableGadget(#String_1,1)
            DisableGadget(#Text_2,1)
            HideGadget(#ListIcon_1,1)
            HideGadget(#String_1,1)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,1)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Email_Body, "")
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 1)
            EmailBody(combo1)
;}
  Case "Close Ticket"
;{************************************
            DisableGadget(#ComboBox_Location,1)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,1)
            HideGadget(#ListIcon_1,1)
            HideGadget(#String_1,0)
            HideGadget(#String_2,0)
            HideGadget(#Text_1,0)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            DisableGadget(#ComboBox_Location,1)
            SetGadgetText(#Text_2,"First & Last Name:")
            SetGadgetText(#String_1, "")
            SetGadgetText(#String_2, "")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            EmailBody(combo1)
;}
  Case "Emergency Maintenance"
;{************************************
            DisableGadget(#String_1,1)
            DisableGadget(#Text_2,1)
            SetGadgetText(#String_1, "")
            DisableGadget(#ComboBox_Location,0)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,0)
            DisableGadget(#ComboBox_EndTime1,0)
            DisableGadget(#ComboBox_TimeZone,0)
            DisableGadget(#Date_1,0)
            DisableGadget(#ComboBox_StartTime2,0)
            DisableGadget(#ComboBox_EndTime2,0)
            DisableGadget(#ComboBox_StartTimeInterval,0)
            DisableGadget(#ComboBox_EndTimeInterval,0)
            DisableGadget(#ListIcon_1,0)
            HideGadget(#ListIcon_1,0)
            HideGadget(#String_1,1)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,1)
            HideGadget(#ComboBox_StartTime1,0)
            HideGadget(#ComboBox_EndTime1,0)
            HideGadget(#ComboBox_TimeZone,0)
            HideGadget(#ComboBox_StartTime2,0)
            HideGadget(#ComboBox_EndTime2,0)
            HideGadget(#ComboBox_StartTimeInterval,0)
            HideGadget(#ComboBox_EndTimeInterval,0)
            HideGadget(#Date_1,0)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            EmailBody(combo1)
;}
  Case "Helpdesk Ticket Reminder"
;{************************************
            DisableGadget(#ComboBox_Location,1)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,1)
            HideGadget(#ListIcon_1,1)
            HideGadget(#String_1,0)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            DisableGadget(#ComboBox_Location,1)
            SetGadgetText(#Text_2,"First & Last Name:")
            SetGadgetText(#String_1, "")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            EmailBody(combo1)
;}
  Case "Issue Detected and Resolved"
;{************************************
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            SetGadgetText(#String_1, "At this time you should be able to ")
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            DisableGadget(#ComboBox_Location,0)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,0)
            HideGadget(#ListIcon_1,0)
            HideGadget(#String_1,0)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            EmailBody(combo1)
;}
  Case "Maintenance"
;{************************************
            DisableGadget(#String_1,1)
            DisableGadget(#Text_2,1)
            SetGadgetText(#String_1, "")
            DisableGadget(#ComboBox_Location,0)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,0)
            DisableGadget(#ComboBox_EndTime1,0)
            DisableGadget(#ComboBox_TimeZone,0)
            DisableGadget(#Date_1,0)
            DisableGadget(#ComboBox_StartTime2,0)
            DisableGadget(#ComboBox_EndTime2,0)
            DisableGadget(#ComboBox_StartTimeInterval,0)
            DisableGadget(#ComboBox_EndTimeInterval,0)
            DisableGadget(#ListIcon_1,0)
            HideGadget(#ListIcon_1,0)
            HideGadget(#String_1,1)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,1)
            HideGadget(#ComboBox_StartTime1,0)
            HideGadget(#ComboBox_EndTime1,0)
            HideGadget(#ComboBox_TimeZone,0)
            HideGadget(#ComboBox_StartTime2,0)
            HideGadget(#ComboBox_EndTime2,0)
            HideGadget(#ComboBox_StartTimeInterval,0)
            HideGadget(#ComboBox_EndTimeInterval,0)
            HideGadget(#Date_1,0)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            EmailBody(combo1)
;}
  Case "Maintenance Complete"
;{************************************
            DisableGadget(#String_1,1)
            DisableGadget(#Text_2,1)
            SetGadgetText(#String_1, "")
            DisableGadget(#ComboBox_Location,0)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,0)
            HideGadget(#ListIcon_1,0)
            HideGadget(#String_1,1)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,1)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            EmailBody(combo1)
;}
  Case "Outage"
;{************************************
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            SetGadgetText(#String_1, "During this time you will be unable to ")
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            DisableGadget(#ComboBox_Location,0)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,0)
            HideGadget(#ListIcon_1,0)
            HideGadget(#String_1,0)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            EmailBody(combo1)
;}
  Case "Resolution"
;{************************************
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            SetGadgetText(#String_1, "At this time you should be able to ")
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            DisableGadget(#ComboBox_Location,0)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,0)
            HideGadget(#ListIcon_1,0)
            HideGadget(#String_1,0)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            SetGadgetText(#Text_2, "Explain Impact on Employees:")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            EmailBody(combo1)
;}
  Case "Technology Request Completed"
;{************************************
            DisableGadget(#ComboBox_Location,1)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,1)
            HideGadget(#ListIcon_1,1)
            HideGadget(#String_1,0)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            DisableGadget(#ComboBox_Location,1)
            SetGadgetText(#Text_2,"First & Last Name:")
            SetGadgetText(#String_1, "")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            EmailBody(combo1)
;}
  Case "Technology Request Needed"
;{************************************
            DisableGadget(#ComboBox_Location,1)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,1)
            HideGadget(#ListIcon_1,1)
            HideGadget(#String_1,0)
            HideGadget(#String_2,1)
            HideGadget(#Text_1,1)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            DisableGadget(#ComboBox_Location,1)
            SetGadgetText(#Text_2,"First & Last Name:")
            SetGadgetText(#String_1, "")
            SetGadgetText(#String_2, "")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            EmailBody(combo1)
;}
  Case "Ticket Follow-Up"
;{************************************
            DisableGadget(#ComboBox_Location,1)
            DisableGadget(#CombBox_AppSystem,1)
            DisableGadget(#ComboBox_SystemType,1)
            DisableGadget(#ComboBox_StartTime1,1)
            DisableGadget(#ComboBox_EndTime1,1)
            DisableGadget(#ComboBox_TimeZone,1)
            DisableGadget(#Date_1,1)
            DisableGadget(#ComboBox_StartTime2,1)
            DisableGadget(#ComboBox_EndTime2,1)
            DisableGadget(#ComboBox_StartTimeInterval,1)
            DisableGadget(#ComboBox_EndTimeInterval,1)
            DisableGadget(#ListIcon_1,1)
            HideGadget(#ListIcon_1,1)
            HideGadget(#String_1,0)
            HideGadget(#String_2,0)
            HideGadget(#Text_1,0)
            HideGadget(#Text_2,0)
            HideGadget(#ComboBox_StartTime1,1)
            HideGadget(#ComboBox_EndTime1,1)
            HideGadget(#ComboBox_TimeZone,1)
            HideGadget(#ComboBox_StartTime2,1)
            HideGadget(#ComboBox_EndTime2,1)
            HideGadget(#ComboBox_StartTimeInterval,1)
            HideGadget(#ComboBox_EndTimeInterval,1)
            HideGadget(#Date_1,1)
            SetGadgetState(#ComboBox_Location,0)
            SetGadgetState(#CombBox_AppSystem,0)
            SetGadgetState(#ComboBox_StartTime1,0)
            SetGadgetState(#ComboBox_EndTime1,0)
            SetGadgetState(#ComboBox_TimeZone,0)
            SetGadgetState(#ComboBox_StartTime2,0)
            SetGadgetState(#ComboBox_EndTime2,0)
            SetGadgetState(#ComboBox_SystemType,0)
            DisableGadget(#String_1,0)
            DisableGadget(#Text_2,0)
            DisableGadget(#ComboBox_Location,1)
            SetGadgetText(#Text_2,"First & Last Name:")
            SetGadgetText(#String_1, "")
            SetGadgetText(#String_2, "")
            SetGadgetAttribute(#Email_Body, #PB_Editor_ReadOnly, 0)
            SetGadgetColor(#String_1,#PB_Gadget_BackColor,RGB(255,255,0))
            EmailBody(combo1)
;}

EndSelect

EndProcedure

Procedure MailRecipient()

        combo2=GetGadgetText(#ComboBox_Location)

        Select combo2

          Case "Select Property:"

           employee = ""
            mainrecipient = ""
             DisableGadget(#CombBox_AppSystem,1)
              DisableGadget(#ComboBox_SystemType,1)
               EmailBody(combo1)

          Case "All Ideal-Tridon Properties"

           employee = "Ideal-Tridon"
            mainrecipient = "Everyone_Matamoros; Tridon-Poland; Everyone_Tridon; Everyone_Suzhou"
             DisableGadget(#CombBox_AppSystem,0)
              EmailBody(combo1)

          Case "Ideal-Tridon Brownsville/Matamoros"

           employee = "Matamoros"
            mainrecipient = "Everyone_Matamoros"
             DisableGadget(#CombBox_AppSystem,0)
              EmailBody(combo1)

          Case "Ideal-Tridon Poland"

           employee = "Poland"
            mainrecipient = "tridon-poland"
             DisableGadget(#CombBox_AppSystem,0)
              EmailBody(combo1)

          Case "Ideal-Tridon Smyrna"

           employee = "Smyrna"
            mainrecipient = "Everyone_Tridon"
             DisableGadget(#CombBox_AppSystem,0)
              EmailBody(combo1)

          Case "Ideal-Tridon Suzhou"

           employee = "Suzhou"
            mainrecipient = "Everyone_Suzhou"
             DisableGadget(#CombBox_AppSystem,0)
              EmailBody(combo1)

        EndSelect
EndProcedure

Procedure AppSystem()

       combo3=GetGadgetText(#CombBox_AppSystem)

        Select combo3

         Case "Select Area:"

               ClearGadgetItems(#ComboBox_SystemType)
               AddGadgetItem(#ComboBox_SystemType,0,"Select Application/System:")
               SetGadgetState(#ComboBox_SystemType,0)
               ClearGadgetItems(#ListIcon_1)
               DisableGadget(#ComboBox_SystemType,1)
               EmailBody(combo1)

         Case "Applications"

               fromfield = "Ideal Information Technology"
               DisableGadget(#ComboBox_SystemType,0)
               ClearGadgetItems(#ComboBox_SystemType)
               ClearGadgetItems(#ListIcon_1)
               AddGadgetItem(#ComboBox_SystemType,0,"Select Application/System:")
               SetGadgetState(#ComboBox_SystemType,0)
               FillGadget(#ComboBox_SystemType,".\DB\Applications.txt")
               EmailBody(combo1)

         Case "Server or System"

               fromfield = "Ideal Information Technology"
               DisableGadget(#ComboBox_SystemType,0)
               ClearGadgetItems(#ComboBox_SystemType)
               ClearGadgetItems(#ListIcon_1)
               AddGadgetItem(#ComboBox_SystemType,0,"Select Server/System:")
               SetGadgetState(#ComboBox_SystemType,0)
               FillGadget(#ComboBox_SystemType,".\DB\Systems.txt")
               FillGadget(#ListIcon_1,".\DB\Applications.txt")
               EmailBody(combo1)

         Case "Telecom Application or System"

               fromfield = "Ideal Information Technology"
               DisableGadget(#ComboBox_SystemType,0)
               ClearGadgetItems(#ComboBox_SystemType)
               ClearGadgetItems(#ListIcon_1)
               AddGadgetItem(#ComboBox_SystemType,0,"Select Application/System:")
               SetGadgetState(#ComboBox_SystemType,0)
               FillGadget(#ComboBox_SystemType,".\DB\Telecom.txt")
               EmailBody(combo1)

        EndSelect
EndProcedure

Procedure SetAllFields(); Sets the following fields: To, Subject, and Attachment Fields of message

  Select combo1
    Case "Issue Detected and Resolved"
      subject = system+" Issue Detected and Resolved"
    Case "Outage"
      subject = system+" Issue Detected"
    Case "Resolution"
      subject = system+" Issue Has Been Resolved"
    Case "Emergency Maintenance"
      subject = system+" Emergency Maintenance"
    Case "Maintenance"
      subject = system+" Maintenance Notification"
    Case "Maintenance Complete"
      subject = system+" Maintenance Completed"
    Case "Ticket Follow-Up"
      mainrecipient = GetGadgetText(#String_1)
       cc = ""
        subject = "Ticket Follow-Up"
    Case "Close Ticket"
      mainrecipient = GetGadgetText(#String_1)
       cc = ""
        subject = "Ticket Closed"
    Case "Helpdesk Ticket Reminder"
      mainrecipient = GetGadgetText(#String_1)
       cc = ""
        subject = "Ticket Reminder"
    Case "Technology Request Completed"
      mainrecipient = GetGadgetText(#String_1)
       cc = ""
        subject = "Technology Request Completed"
         attach=OpenFileRequester("IT Information Card","C:\Temp\*.xps","IT Information Card (*.xps)|*.xps",0)
    Case "Technology Request Needed"
      mainrecipient = GetGadgetText(#String_1)
       cc = ""
        subject = "Technology Request Form Required"
  EndSelect

EndProcedure
;}
;**************************

;***************************
;{***** Check Database *****
CheckForDB()
;}
;***************************

;**********************************
;{***** Create Window/Gadgets *****
;{-=Code to Ensure Only One Instance of Program Running=-
*MyMutex = CreateMutex_(#Null, 1, "IT-Mailer")
MutexError=GetLastError_()
If *MyMutex=0 Or MutexError<>0
  MessageRequester("Error","Mailer is already running !!!",#MB_ICONWARNING)
  End
EndIf
;}
OpenWindow(#Window_0, 2, 2, 800, 820, "IT E-mail Creator", #PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_TitleBar|#PB_Window_ScreenCentered)
 SetWindowCallback(@WinCallback())

;{ ComboBox 1 - Mail Type
ComboBoxGadget(#ComboBox_Email_Type, 5, 2, 200, 23)
  AddGadgetItem(#ComboBox_Email_Type,0,"Select E-Mail Type:")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Close Ticket")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Emergency Maintenance")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Helpdesk Ticket Reminder")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Issue Detected and Resolved")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Maintenance")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Maintenance Complete")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Outage")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Resolution")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Technology Request Completed")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Technology Request Needed")
  AddGadgetItem(#ComboBox_Email_Type,-1,"Ticket Follow-Up")
SetGadgetState(#ComboBox_Email_Type,0)
;}

;{ ComboBox 2 - Properties
ComboBoxGadget(#ComboBox_Location, 5, 27, 200, 23)
  AddGadgetItem(#ComboBox_Location,0,"Select Property:")
  AddGadgetItem(#ComboBox_Location,-1,"All Ideal-Tridon Properties")
  AddGadgetItem(#ComboBox_Location,-1,"Ideal-Tridon Brownsville/Matamoros")
  AddGadgetItem(#ComboBox_Location,-1,"Ideal-Tridon Poland")
  AddGadgetItem(#ComboBox_Location,-1,"Ideal-Tridon Smyrna")
  AddGadgetItem(#ComboBox_Location,-1,"Ideal-Tridon Suzhou")
SetGadgetState(#ComboBox_Location,0)
  DisableGadget(#ComboBox_Location,1)
;}

;{ ComboBox 3 - Area
ComboBoxGadget(#CombBox_AppSystem, 5, 52, 200, 23)
  AddGadgetItem(#CombBox_AppSystem,0,"Select Area:")
  AddGadgetItem(#CombBox_AppSystem,-1,"Applications")
  AddGadgetItem(#CombBox_AppSystem,-1,"Server or System")
  AddGadgetItem(#CombBox_AppSystem,-1,"Telecom Application or System")
SetGadgetState(#CombBox_AppSystem,0)
  DisableGadget(#CombBox_AppSystem,1)
;}

;{ ComboBox 4 - Application/System Selection Box
ComboBoxGadget(#ComboBox_SystemType,5,77,200,23)
  AddGadgetItem(#ComboBox_SystemType,0,"Select Application/System:")
SetGadgetState(#ComboBox_SystemType,0)
  DisableGadget(#ComboBox_SystemType,1)
;}

;{ (Dis)Allow GUI drawing to window
SendMessage_(WindowID(#Window_0),#WM_SETREDRAW, #False, 0)

;{ ComboBox 5 - Start Time
ComboBoxGadget(#ComboBox_StartTime1,210,27,78,23)
  AddGadgetItem(#ComboBox_StartTime1,0,"Start Time")
    For timestart = 1 To 12
      AddGadgetItem(#ComboBox_StartTime1, -1,Str(timestart))
    Next timestart
SetGadgetState(#ComboBox_StartTime1,0)
 HideGadget(#ComboBox_StartTime1,1)
;}

;{ ComboBox 6 - End Time
ComboBoxGadget(#ComboBox_EndTime1,210,52,78,23)
  AddGadgetItem(#ComboBox_EndTime1,0,"End Time")
    For timeend = 1 To 12
      AddGadgetItem(#ComboBox_EndTime1, -1,Str(timeend))
    Next timeend
SetGadgetState(#ComboBox_EndTime1,0)
 HideGadget(#ComboBox_EndTime1,1)
;}

;{ ComboBox 7 - TimeZone
ComboBoxGadget(#ComboBox_TimeZone,210,77,135,23)
  AddGadgetItem(#ComboBox_TimeZone,0,"Select Time Zone:")
  AddGadgetItem(#ComboBox_TimeZone,-1,"Central")
  AddGadgetItem(#ComboBox_TimeZone,-1,"Eastern")
  AddGadgetItem(#ComboBox_TimeZone,-1,"Mountain")
  AddGadgetItem(#ComboBox_TimeZone,-1,"Pacific")
  AddGadgetItem(#ComboBox_TimeZone,-1,"CET (UTC +1)")
  AddGadgetItem(#ComboBox_TimeZone,-1,"CEST (UTC +2)")
SetGadgetState(#ComboBox_TimeZone,0)
 HideGadget(#ComboBox_TimeZone,1)
;}

;{ ComboBox 8 - Start Time AM/PM
ComboBoxGadget(#ComboBox_StartTime2,346,27,47,23)
  AddGadgetItem(#ComboBox_StartTime2, -1, "a.m.")
  AddGadgetItem(#ComboBox_StartTime2, -1, "p.m.")
SetGadgetState(#ComboBox_StartTime2,0)
 HideGadget(#ComboBox_StartTime2,1)
;}

;{ ComboBox 9 - End Time AM/PM
ComboBoxGadget(#ComboBox_EndTime2,346,52,47,23)
  AddGadgetItem(#ComboBox_EndTime2, -1, "a.m.")
  AddGadgetItem(#ComboBox_EndTime2, -1, "p.m.")
SetGadgetState(#ComboBox_EndTime2,0)
 HideGadget(#ComboBox_EndTime2,1)
;}

;{ ComboBox 10 - Start Time Interval
ComboBoxGadget(#ComboBox_StartTimeInterval,294,27,45,23)
  AddGadgetItem(#ComboBox_StartTimeInterval,-1,":00")
  AddGadgetItem(#ComboBox_StartTimeInterval,-1,":15")
  AddGadgetItem(#ComboBox_StartTimeInterval,-1,":30")
  AddGadgetItem(#ComboBox_StartTimeInterval,-1,":45")
SetGadgetState(#ComboBox_StartTimeInterval,0)
 HideGadget(#ComboBox_StartTimeInterval,1)
;}

;{ ComboBox 11 - End Time Interval
ComboBoxGadget(#ComboBox_EndTimeInterval,294,52,45,23)
  AddGadgetItem(#ComboBox_EndTimeInterval,-1,":00")
  AddGadgetItem(#ComboBox_EndTimeInterval,-1,":15")
  AddGadgetItem(#ComboBox_EndTimeInterval,-1,":30")
  AddGadgetItem(#ComboBox_EndTimeInterval,-1,":45")
SetGadgetState(#ComboBox_EndTimeInterval,0)
 HideGadget(#ComboBox_EndTimeInterval,1)
;}

;{ Date Gadget - Select Date for Maintenance

DateGadget(#Date_1,210,2,183,23,"Start Date: %mm/%dd/%yyyy")
 HideGadget(#Date_1,1)
;}

;{ ListIcon 1 - System/Application Selection Box
ListIconGadget(#ListIcon_1,400,3,287,150,"Affected Applications (Hold Ctrl for Multi)",266,#PB_ListIcon_MultiSelect|#PB_ListIcon_AlwaysShowSelection)
  HideGadget(#ListIcon_1,1)
  DisableGadget(#ListIcon_1,1)
SetGadgetColor(#ListIcon_1,#PB_Gadget_BackColor,RGB(255,255,0))
;}

;{ String Gadget 1 - Impact on Employees/First Name and Last Name
StringGadget(#String_1, 112, 165, 445, 22, "")
  TextGadget(#Text_2, 3, 168, 109, 16,"Explain Impact on Employees:")
DisableGadget(#String_1,1)
DisableGadget(#Text_2,1)
HideGadget(#String_1,1)
HideGadget(#Text_2,1)
;}

;{ String Gadget 2 - Ticket#
StringGadget(#String_2,615,165,140,22,"",#PB_String_Numeric)
  TextGadget(#Text_1,570,168,40,20,"Ticket#:")
SendMessage_(GadgetID(#String_2), #EM_LIMITTEXT, 10, 0)
SetGadgetColor(#String_2,#PB_Gadget_BackColor,RGB(255,255,0))
HideGadget(#String_2,1)
HideGadget(#Text_1,1)
;}

;Allow GUI to draw to window
SendMessage_(WindowID(#Window_0),#WM_SETREDRAW, #True, 0)
;}

;{ Image Button 4 - Send to Outlook
ButtonImageGadget(#Button_Send_Email,695,5,100,30,CatchImage(#Image_ButtonImage_4, ?Image_ButtonImage_4))
  GadgetToolTip(#Button_Send_Email, "Send to Outlook")
   DisableGadget(#Button_Send_Email,1)
;}

;{ Frame Gadget
  FrameGadget(#PB_Any,692,45,106,52,"Format Text")
   ButtonImageGadget(#Button_Bold,695,60,30,30,CatchImage(#Image_ButtonImage_1, ?Image_ButtonImage_1))
    GadgetToolTip(#Button_Bold, "Bold selection")
   ButtonImageGadget(#Button_Italic,730,60,30,30,CatchImage(#Image_ButtonImage_2, ?Image_ButtonImage_2))
    GadgetToolTip(#Button_Italic, "Italicize selection")
   ButtonImageGadget(#Button_Bullets,765,60,30,30,CatchImage(#Image_ButtonImage_3, ?Image_ButtonImage_3))
    GadgetToolTip(#Button_Bullets, "Bulletize selection")
;}

;{ Editor Gadget - E-Mail Body
EditorGadget(#Email_Body, 2, 190, 796, 628);|1);0-Left,1-Center,2-Right
  RichEdit_SetInterface(GadgetID(#Email_Body))
    SendMessage_(GadgetID(#Email_Body), #EM_SETEVENTMASK, 0, #ENM_KEYEVENTS); - Enable keyboard shortcuts
      Editor_Wrap(#Email_Body,-1); Enable wordwrapping
SetGadgetAttribute(#Email_Body,#PB_Editor_ReadOnly,1)
  SetGadgetFont(#Email_Body,LoadFont(#Font_Editor_0,"Century Gothic",10));,#PB_Font_HighQuality))
;}
;}
;**********************************

;**********************
;{***** Main Loop *****

;{ Start Outlook if it's not already running
myhwnd=FindPartWin("Outlook");
 If myhwnd=0
   mesg=MessageRequester("Error - Outlook Required","Outlook is not running, do you wish to start Outlook?",#PB_MessageRequester_YesNo|#MB_ICONWARNING)
    If mesg=#PB_MessageRequester_Yes
      RunProgram("outlook")
    Else
      MessageRequester("Error","This application requires Outlook, closing...",#MB_ICONINFORMATION)
       End
    EndIf
 EndIf
;}

Repeat

 event=WaitWindowEvent(1)
  DisableSendButton()
   DisableAppList()
    ;HideUnusedGadgets()

  Select event

    Case #PB_Event_Gadget

      Select EventGadget()

;{ ComboBox 1 Events - E-mail Type

       Case #ComboBox_Email_Type

        MailType()
;}

;{ ComboBox 2 Events - E-Mail Recipient

       Case #ComboBox_Location

        MailRecipient()
;}

;{ ComboBox 3 and 4 Events - Application/System

       Case #CombBox_AppSystem

        AppSystem()

       Case #ComboBox_SystemType

        EmailBody(combo1)

;}

;{ Format Buttons

;*** Bold Selection ***
       Case #Button_Bold

        Editor_Format(#Email_Body,#CFE_BOLD,1)
            
;*** Italicize Selection ***
       Case #Button_Italic

        Editor_Format(#Email_Body,#CFE_ITALIC,1)
            
;*** Bulletize Selection ***
       Case #Button_Bullets

        Editor_Bulleted(#Email_Body)
;}

;{ ButtonImage 4 - Cut Editor Text, Create E-mail Message & Paste Contents,Etc.
      
       Case #Button_Send_Email
        string1=GetGadgetText(#String_1)
         Editor_Select(#Email_Body, 0, 0, -1, -1)
          Editor_CutText(#Email_Body)
        OutlookObject = COMate_CreateObject("Outlook.Application")
          fromfield="itsupport@idealtridon.com"
           SetAllFields()
        If OutlookObject
         myhwnd=FindPartWin("Outlook")
          BringWindowToTop_(myhwnd)
           olMsg = OutlookObject\GetObjectProperty("CreateItem(0)")
         If olMsg
           olMsg\SetProperty("SentOnBehalfOfName='"+fromfield+"'"); From field
           olMsg\SetProperty("To='"+mainrecipient+"'")
           olMsg\SetProperty("CC='"+cc+"'"); Carbon Copy
           olMsg\SetProperty("BCC='"+bcc+"'");Blind Carbon Copy
           olMsg\SetProperty("Subject='"+subject+"'"); Subject
           olMsg\SetProperty("Importance='2'");0 for Low, 1 for Normal, 2 for High
          If combo1 = "Technology Request Completed"
            olMsg\Invoke("Attachments\Add('"+attach+"')")
          EndIf
           olMsg\SetProperty("BodyFormat='2'");1 for Plain Text, 2 for HTML, 3 for RTF
           olMsg\SetProperty("Body=''")
           olMsg\Invoke("Display")
            Delay(250)
             keybd_event_(#VK_CONTROL,0,0,0)
              keybd_event_(#VK_V,0,0,0)
               keybd_event_(#VK_CONTROL,0,#KEYEVENTF_KEYUP,0)
                keybd_event_(#VK_V,0,#KEYEVENTF_KEYUP,0)
           olMsg\Release() 
         EndIf
           OutlookObject\Release()
        EndIf
         ResetMailer()
;}

;{ ListIcon 1 - Select Applications

       Case #ListIcon_1

         selected = ""
         ; --> Get the total number of items selected
         totalItemsSelected = SendMessage_(GadgetID(#ListIcon_1), #LVM_GETSELECTEDCOUNT, 0, 0)
         ; --> We'll start searching from the beginning
         currentItem = -1
         ; --> Loop through the ListIconGadget looking for selected items
         ; --> As soon as we have collected all selected items, we're done
         For i = 1 To totalItemsSelected
           thisSelectedItem = SendMessage_(GadgetID(#ListIcon_1), #LVM_GETNEXTITEM, currentItem, #LVNI_ALL | #LVNI_SELECTED)
           ; --> Get the selected item text
           selected + GetGadgetItemText(#ListIcon_1, thisSelectedItem, 0) + #CRLF$
           ; --> move on to next item
           currentItem = thisSelectedItem
         Next i

         If totalItemsSelected<>0
           DisableGadget(#String_1,1)
            SetGadgetText(#String_1,"")
         EndIf
         EmailBody(combo1)
;}

;{ Calendar Gadgets

       Case #Date_1

        date=GetGadgetState(#Date_1)
         EmailBody(combo1)

;}

;{ Update Editor Text

       Case #PB_Any

        EmailBody(combo1)
;}

      EndSelect

  EndSelect

;{ Update Editor with String Text

  Select EventType()

    Case #PB_EventType_Change

     description=GetGadgetText(#String_1)
      ticket=GetGadgetText(#String_2)
       If combo1<>"Helpdesk Ticket Reminder"
         EmailBody(combo1)
       EndIf
  EndSelect
;}

Until event = #PB_Event_CloseWindow

;{-=End Code to Ensure Only One Instance of Program Running=-
ReleaseMutex_(*MyMutex)
CloseHandle_(*MyMutex)
;}
End
;}
;**********************

;*************************
;{***** Data Section *****
;Included Images
DataSection
  Image_ButtonImage_1:
  IncludeBinary ".\gfx\bold.ico"
  Image_ButtonImage_2:
  IncludeBinary ".\gfx\italic.ico"
  Image_ButtonImage_3:
  IncludeBinary ".\gfx\bullet.ico"
  Image_ButtonImage_4:
  IncludeBinary ".\gfx\send.ico"
EndDataSection
;}
;*************************
; IDE Options = PureBasic 5.71 LTS (Windows - x64)
; CursorPosition = 8
; Folding = AAAAAAAAAAAAA+
; EnableXP
; UseIcon = gfx\mail2.ico
; Executable = ..\Mailer.exe
; VersionField0 = 1.04.33.0
; VersionField1 = 1.04.33.0
; VersionField2 = GET
; VersionField3 = ISS Support E-Mail Template Creator
; VersionField4 = 1.04.33.0
; VersionField5 = 1.04.33.0
; VersionField6 = ISS Support E-Mail Template Creator
; VersionField7 = Mailer
; VersionField8 = Mailer.exe
; VersionField9 = Daniel Ford
; VersionField13 = dford@gaylordentertainment.com
; VersionField15 = VOS_NT_WINDOWS32
; VersionField16 = VFT_APP
; VersionField17 = 0409 English (United States)